package zio.aws.macie.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateS3ResourcesResponse(
    failedS3Resources: Option[Iterable[zio.aws.macie.model.FailedS3Resource]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesResponse = {
    import DisassociateS3ResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesResponse
      .builder()
      .optionallyWith(
        failedS3Resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedS3Resources)
      .build()
  }
  def asReadOnly: zio.aws.macie.model.DisassociateS3ResourcesResponse.ReadOnly =
    zio.aws.macie.model.DisassociateS3ResourcesResponse.wrap(buildAwsValue())
}
object DisassociateS3ResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie.model.DisassociateS3ResourcesResponse =
      zio.aws.macie.model.DisassociateS3ResourcesResponse(
        failedS3Resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedS3Resources
        : Option[List[zio.aws.macie.model.FailedS3Resource.ReadOnly]]
    def getFailedS3Resources: ZIO[Any, AwsError, List[
      zio.aws.macie.model.FailedS3Resource.ReadOnly
    ]] = AwsError.unwrapOptionField("failedS3Resources", failedS3Resources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesResponse
  ) extends zio.aws.macie.model.DisassociateS3ResourcesResponse.ReadOnly {
    override val failedS3Resources
        : Option[List[zio.aws.macie.model.FailedS3Resource.ReadOnly]] = scala
      .Option(impl.failedS3Resources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie.model.FailedS3Resource.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie.model.DisassociateS3ResourcesResponse
  ): zio.aws.macie.model.DisassociateS3ResourcesResponse.ReadOnly = new Wrapper(
    impl
  )
}
