package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__long, __boolean}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ServiceLimit(
    isServiceLimited: Optional[__boolean] = Optional.Absent,
    unit: Optional[zio.aws.macie2.model.Unit] = Optional.Absent,
    value: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ServiceLimit = {
    import ServiceLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ServiceLimit
      .builder()
      .optionallyWith(isServiceLimited.map(value => value: java.lang.Boolean))(
        _.isServiceLimited
      )
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(value.map(value => value: java.lang.Long))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ServiceLimit.ReadOnly =
    zio.aws.macie2.model.ServiceLimit.wrap(buildAwsValue())
}
object ServiceLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ServiceLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ServiceLimit =
      zio.aws.macie2.model.ServiceLimit(
        isServiceLimited.map(value => value),
        unit.map(value => value),
        value.map(value => value)
      )
    def isServiceLimited: Optional[__boolean]
    def unit: Optional[zio.aws.macie2.model.Unit]
    def value: Optional[__long]
    def getIsServiceLimited: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isServiceLimited", isServiceLimited)
    def getUnit: ZIO[Any, AwsError, zio.aws.macie2.model.Unit] =
      AwsError.unwrapOptionField("unit", unit)
    def getValue: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ServiceLimit
  ) extends zio.aws.macie2.model.ServiceLimit.ReadOnly {
    override val isServiceLimited: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isServiceLimited())
      .map(value => value: __boolean)
    override val unit: Optional[zio.aws.macie2.model.Unit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.macie2.model.Unit.wrap(value))
    override val value: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ServiceLimit
  ): zio.aws.macie2.model.ServiceLimit.ReadOnly = new Wrapper(impl)
}
