package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class S3ClassificationScope(
    excludes: zio.aws.macie2.model.S3ClassificationScopeExclusion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.S3ClassificationScope = {
    import S3ClassificationScope.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3ClassificationScope
      .builder()
      .excludes(excludes.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3ClassificationScope.ReadOnly =
    zio.aws.macie2.model.S3ClassificationScope.wrap(buildAwsValue())
}
object S3ClassificationScope {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.S3ClassificationScope
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3ClassificationScope =
      zio.aws.macie2.model.S3ClassificationScope(excludes.asEditable)
    def excludes: zio.aws.macie2.model.S3ClassificationScopeExclusion.ReadOnly
    def getExcludes: ZIO[
      Any,
      Nothing,
      zio.aws.macie2.model.S3ClassificationScopeExclusion.ReadOnly
    ] = ZIO.succeed(excludes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3ClassificationScope
  ) extends zio.aws.macie2.model.S3ClassificationScope.ReadOnly {
    override val excludes
        : zio.aws.macie2.model.S3ClassificationScopeExclusion.ReadOnly =
      zio.aws.macie2.model.S3ClassificationScopeExclusion.wrap(impl.excludes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3ClassificationScope
  ): zio.aws.macie2.model.S3ClassificationScope.ReadOnly = new Wrapper(impl)
}
