package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ManagedDataIdentifierSummary(
    category: Optional[zio.aws.macie2.model.SensitiveDataItemCategory] =
      Optional.Absent,
    id: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ManagedDataIdentifierSummary = {
    import ManagedDataIdentifierSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ManagedDataIdentifierSummary
      .builder()
      .optionallyWith(category.map(value => value.unwrap))(_.category)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ManagedDataIdentifierSummary.ReadOnly =
    zio.aws.macie2.model.ManagedDataIdentifierSummary.wrap(buildAwsValue())
}
object ManagedDataIdentifierSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ManagedDataIdentifierSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ManagedDataIdentifierSummary =
      zio.aws.macie2.model.ManagedDataIdentifierSummary(
        category.map(value => value),
        id.map(value => value)
      )
    def category: Optional[zio.aws.macie2.model.SensitiveDataItemCategory]
    def id: Optional[__string]
    def getCategory
        : ZIO[Any, AwsError, zio.aws.macie2.model.SensitiveDataItemCategory] =
      AwsError.unwrapOptionField("category", category)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ManagedDataIdentifierSummary
  ) extends zio.aws.macie2.model.ManagedDataIdentifierSummary.ReadOnly {
    override val category
        : Optional[zio.aws.macie2.model.SensitiveDataItemCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.category())
        .map(value =>
          zio.aws.macie2.model.SensitiveDataItemCategory.wrap(value)
        )
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ManagedDataIdentifierSummary
  ): zio.aws.macie2.model.ManagedDataIdentifierSummary.ReadOnly = new Wrapper(
    impl
  )
}
