package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, __long}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DefaultDetection(
    count: Optional[__long] = Optional.Absent,
    occurrences: Optional[zio.aws.macie2.model.Occurrences] = Optional.Absent,
    `type`: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.DefaultDetection = {
    import DefaultDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.DefaultDetection
      .builder()
      .optionallyWith(count.map(value => value: java.lang.Long))(_.count)
      .optionallyWith(occurrences.map(value => value.buildAwsValue()))(
        _.occurrences
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.DefaultDetection.ReadOnly =
    zio.aws.macie2.model.DefaultDetection.wrap(buildAwsValue())
}
object DefaultDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.DefaultDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.DefaultDetection =
      zio.aws.macie2.model.DefaultDetection(
        count.map(value => value),
        occurrences.map(value => value.asEditable),
        `type`.map(value => value)
      )
    def count: Optional[__long]
    def occurrences: Optional[zio.aws.macie2.model.Occurrences.ReadOnly]
    def `type`: Optional[__string]
    def getCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("count", count)
    def getOccurrences
        : ZIO[Any, AwsError, zio.aws.macie2.model.Occurrences.ReadOnly] =
      AwsError.unwrapOptionField("occurrences", occurrences)
    def getType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.DefaultDetection
  ) extends zio.aws.macie2.model.DefaultDetection.ReadOnly {
    override val count: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: __long)
    override val occurrences
        : Optional[zio.aws.macie2.model.Occurrences.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.occurrences())
        .map(value => zio.aws.macie2.model.Occurrences.wrap(value))
    override val `type`: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.DefaultDetection
  ): zio.aws.macie2.model.DefaultDetection.ReadOnly = new Wrapper(impl)
}
