package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{
  ClassificationScopeName,
  ClassificationScopeId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClassificationScopeSummary(
    id: Optional[ClassificationScopeId] = Optional.Absent,
    name: Optional[ClassificationScopeName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ClassificationScopeSummary = {
    import ClassificationScopeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ClassificationScopeSummary
      .builder()
      .optionallyWith(
        id.map(value => ClassificationScopeId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value =>
          ClassificationScopeName.unwrap(value): java.lang.String
        )
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ClassificationScopeSummary.ReadOnly =
    zio.aws.macie2.model.ClassificationScopeSummary.wrap(buildAwsValue())
}
object ClassificationScopeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ClassificationScopeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ClassificationScopeSummary =
      zio.aws.macie2.model.ClassificationScopeSummary(
        id.map(value => value),
        name.map(value => value)
      )
    def id: Optional[ClassificationScopeId]
    def name: Optional[ClassificationScopeName]
    def getId: ZIO[Any, AwsError, ClassificationScopeId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ClassificationScopeName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationScopeSummary
  ) extends zio.aws.macie2.model.ClassificationScopeSummary.ReadOnly {
    override val id: Optional[ClassificationScopeId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.macie2.model.primitives.ClassificationScopeId(value)
      )
    override val name: Optional[ClassificationScopeName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.macie2.model.primitives.ClassificationScopeName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationScopeSummary
  ): zio.aws.macie2.model.ClassificationScopeSummary.ReadOnly = new Wrapper(
    impl
  )
}
