package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClassificationResultStatus(
    code: Optional[__string] = Optional.Absent,
    reason: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ClassificationResultStatus = {
    import ClassificationResultStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ClassificationResultStatus
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ClassificationResultStatus.ReadOnly =
    zio.aws.macie2.model.ClassificationResultStatus.wrap(buildAwsValue())
}
object ClassificationResultStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ClassificationResultStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ClassificationResultStatus =
      zio.aws.macie2.model.ClassificationResultStatus(
        code.map(value => value),
        reason.map(value => value)
      )
    def code: Optional[__string]
    def reason: Optional[__string]
    def getCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("code", code)
    def getReason: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationResultStatus
  ) extends zio.aws.macie2.model.ClassificationResultStatus.ReadOnly {
    override val code: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: __string)
    override val reason: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationResultStatus
  ): zio.aws.macie2.model.ClassificationResultStatus.ReadOnly = new Wrapper(
    impl
  )
}
