package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait FindingsFilterAction {
  def unwrap: software.amazon.awssdk.services.macie2.model.FindingsFilterAction
}
object FindingsFilterAction {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.FindingsFilterAction
  ): zio.aws.macie2.model.FindingsFilterAction = value match {
    case software.amazon.awssdk.services.macie2.model.FindingsFilterAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.FindingsFilterAction.ARCHIVE =>
      val r = ARCHIVE
      r
    case software.amazon.awssdk.services.macie2.model.FindingsFilterAction.NOOP =>
      val r = NOOP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.FindingsFilterAction {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingsFilterAction =
      software.amazon.awssdk.services.macie2.model.FindingsFilterAction.UNKNOWN_TO_SDK_VERSION
  }
  case object ARCHIVE extends zio.aws.macie2.model.FindingsFilterAction {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingsFilterAction =
      software.amazon.awssdk.services.macie2.model.FindingsFilterAction.ARCHIVE
  }
  case object NOOP extends zio.aws.macie2.model.FindingsFilterAction {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.FindingsFilterAction =
      software.amazon.awssdk.services.macie2.model.FindingsFilterAction.NOOP
  }
}
