package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__string, __timestampIso8601}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UserPausedDetails(
    jobExpiresAt: Optional[__timestampIso8601] = Optional.Absent,
    jobImminentExpirationHealthEventArn: Optional[__string] = Optional.Absent,
    jobPausedAt: Optional[__timestampIso8601] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UserPausedDetails = {
    import UserPausedDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UserPausedDetails
      .builder()
      .optionallyWith(jobExpiresAt.map(value => value: Instant))(_.jobExpiresAt)
      .optionallyWith(
        jobImminentExpirationHealthEventArn.map(value =>
          value: java.lang.String
        )
      )(_.jobImminentExpirationHealthEventArn)
      .optionallyWith(jobPausedAt.map(value => value: Instant))(_.jobPausedAt)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UserPausedDetails.ReadOnly =
    zio.aws.macie2.model.UserPausedDetails.wrap(buildAwsValue())
}
object UserPausedDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UserPausedDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UserPausedDetails =
      zio.aws.macie2.model.UserPausedDetails(
        jobExpiresAt.map(value => value),
        jobImminentExpirationHealthEventArn.map(value => value),
        jobPausedAt.map(value => value)
      )
    def jobExpiresAt: Optional[__timestampIso8601]
    def jobImminentExpirationHealthEventArn: Optional[__string]
    def jobPausedAt: Optional[__timestampIso8601]
    def getJobExpiresAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("jobExpiresAt", jobExpiresAt)
    def getJobImminentExpirationHealthEventArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "jobImminentExpirationHealthEventArn",
        jobImminentExpirationHealthEventArn
      )
    def getJobPausedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("jobPausedAt", jobPausedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UserPausedDetails
  ) extends zio.aws.macie2.model.UserPausedDetails.ReadOnly {
    override val jobExpiresAt: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobExpiresAt())
        .map(value => value: __timestampIso8601)
    override val jobImminentExpirationHealthEventArn: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobImminentExpirationHealthEventArn())
        .map(value => value: __string)
    override val jobPausedAt: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobPausedAt())
        .map(value => value: __timestampIso8601)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UserPausedDetails
  ): zio.aws.macie2.model.UserPausedDetails.ReadOnly = new Wrapper(impl)
}
