package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait Type {
  def unwrap: software.amazon.awssdk.services.macie2.model.Type
}
object Type {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.Type
  ): zio.aws.macie2.model.Type = value match {
    case software.amazon.awssdk.services.macie2.model.Type.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.Type.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.macie2.model.Type.AES256 =>
      val r = AES256
      r
    case software.amazon.awssdk.services.macie2.model.Type.AWS_KMS =>
      val r = `aws:kms`
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.Type {
    override def unwrap: software.amazon.awssdk.services.macie2.model.Type =
      software.amazon.awssdk.services.macie2.model.Type.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.macie2.model.Type {
    override def unwrap: software.amazon.awssdk.services.macie2.model.Type =
      software.amazon.awssdk.services.macie2.model.Type.NONE
  }
  case object AES256 extends zio.aws.macie2.model.Type {
    override def unwrap: software.amazon.awssdk.services.macie2.model.Type =
      software.amazon.awssdk.services.macie2.model.Type.AES256
  }
  case object `aws:kms` extends zio.aws.macie2.model.Type {
    override def unwrap: software.amazon.awssdk.services.macie2.model.Type =
      software.amazon.awssdk.services.macie2.model.Type.AWS_KMS
  }
}
