package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait OriginType {
  def unwrap: software.amazon.awssdk.services.macie2.model.OriginType
}
object OriginType {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.OriginType
  ): zio.aws.macie2.model.OriginType = value match {
    case software.amazon.awssdk.services.macie2.model.OriginType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.OriginType.SENSITIVE_DATA_DISCOVERY_JOB =>
      val r = SENSITIVE_DATA_DISCOVERY_JOB
      r
    case software.amazon.awssdk.services.macie2.model.OriginType.AUTOMATED_SENSITIVE_DATA_DISCOVERY =>
      val r = AUTOMATED_SENSITIVE_DATA_DISCOVERY
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.OriginType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.OriginType =
      software.amazon.awssdk.services.macie2.model.OriginType.UNKNOWN_TO_SDK_VERSION
  }
  case object SENSITIVE_DATA_DISCOVERY_JOB
      extends zio.aws.macie2.model.OriginType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.OriginType =
      software.amazon.awssdk.services.macie2.model.OriginType.SENSITIVE_DATA_DISCOVERY_JOB
  }
  case object AUTOMATED_SENSITIVE_DATA_DISCOVERY
      extends zio.aws.macie2.model.OriginType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.OriginType =
      software.amazon.awssdk.services.macie2.model.OriginType.AUTOMATED_SENSITIVE_DATA_DISCOVERY
  }
}
