package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetMemberResponse(
    accountId: Optional[__string] = Optional.Absent,
    administratorAccountId: Optional[__string] = Optional.Absent,
    arn: Optional[__string] = Optional.Absent,
    email: Optional[__string] = Optional.Absent,
    invitedAt: Optional[__timestampIso8601] = Optional.Absent,
    masterAccountId: Optional[__string] = Optional.Absent,
    relationshipStatus: Optional[zio.aws.macie2.model.RelationshipStatus] =
      Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    updatedAt: Optional[__timestampIso8601] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetMemberResponse = {
    import GetMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetMemberResponse
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(
        administratorAccountId.map(value => value: java.lang.String)
      )(_.administratorAccountId)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(email.map(value => value: java.lang.String))(_.email)
      .optionallyWith(invitedAt.map(value => value: Instant))(_.invitedAt)
      .optionallyWith(masterAccountId.map(value => value: java.lang.String))(
        _.masterAccountId
      )
      .optionallyWith(relationshipStatus.map(value => value.unwrap))(
        _.relationshipStatus
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(updatedAt.map(value => value: Instant))(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetMemberResponse.ReadOnly =
    zio.aws.macie2.model.GetMemberResponse.wrap(buildAwsValue())
}
object GetMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetMemberResponse =
      zio.aws.macie2.model.GetMemberResponse(
        accountId.map(value => value),
        administratorAccountId.map(value => value),
        arn.map(value => value),
        email.map(value => value),
        invitedAt.map(value => value),
        masterAccountId.map(value => value),
        relationshipStatus.map(value => value),
        tags.map(value => value),
        updatedAt.map(value => value)
      )
    def accountId: Optional[__string]
    def administratorAccountId: Optional[__string]
    def arn: Optional[__string]
    def email: Optional[__string]
    def invitedAt: Optional[__timestampIso8601]
    def masterAccountId: Optional[__string]
    def relationshipStatus: Optional[zio.aws.macie2.model.RelationshipStatus]
    def tags: Optional[Map[__string, __string]]
    def updatedAt: Optional[__timestampIso8601]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAdministratorAccountId: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("administratorAccountId", administratorAccountId)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getEmail: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("email", email)
    def getInvitedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("invitedAt", invitedAt)
    def getMasterAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("masterAccountId", masterAccountId)
    def getRelationshipStatus
        : ZIO[Any, AwsError, zio.aws.macie2.model.RelationshipStatus] =
      AwsError.unwrapOptionField("relationshipStatus", relationshipStatus)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetMemberResponse
  ) extends zio.aws.macie2.model.GetMemberResponse.ReadOnly {
    override val accountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: __string)
    override val administratorAccountId: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.administratorAccountId())
        .map(value => value: __string)
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val email: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value => value: __string)
    override val invitedAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.invitedAt())
      .map(value => value: __timestampIso8601)
    override val masterAccountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.masterAccountId())
      .map(value => value: __string)
    override val relationshipStatus
        : Optional[zio.aws.macie2.model.RelationshipStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationshipStatus())
        .map(value => zio.aws.macie2.model.RelationshipStatus.wrap(value))
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val updatedAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => value: __timestampIso8601)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetMemberResponse
  ): zio.aws.macie2.model.GetMemberResponse.ReadOnly = new Wrapper(impl)
}
