package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SearchResourcesResponse(
    matchingResources: Optional[
      Iterable[zio.aws.macie2.model.MatchingResource]
    ] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SearchResourcesResponse = {
    import SearchResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SearchResourcesResponse
      .builder()
      .optionallyWith(
        matchingResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.matchingResources)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SearchResourcesResponse.ReadOnly =
    zio.aws.macie2.model.SearchResourcesResponse.wrap(buildAwsValue())
}
object SearchResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SearchResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SearchResourcesResponse =
      zio.aws.macie2.model.SearchResourcesResponse(
        matchingResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def matchingResources
        : Optional[List[zio.aws.macie2.model.MatchingResource.ReadOnly]]
    def nextToken: Optional[__string]
    def getMatchingResources: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.MatchingResource.ReadOnly
    ]] = AwsError.unwrapOptionField("matchingResources", matchingResources)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesResponse
  ) extends zio.aws.macie2.model.SearchResourcesResponse.ReadOnly {
    override val matchingResources
        : Optional[List[zio.aws.macie2.model.MatchingResource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.matchingResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.MatchingResource.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesResponse
  ): zio.aws.macie2.model.SearchResourcesResponse.ReadOnly = new Wrapper(impl)
}
