package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteAllowListRequest(
    id: __string,
    ignoreJobChecks: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.DeleteAllowListRequest = {
    import DeleteAllowListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.DeleteAllowListRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(ignoreJobChecks.map(value => value: java.lang.String))(
        _.ignoreJobChecks
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.DeleteAllowListRequest.ReadOnly =
    zio.aws.macie2.model.DeleteAllowListRequest.wrap(buildAwsValue())
}
object DeleteAllowListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.DeleteAllowListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.DeleteAllowListRequest =
      zio.aws.macie2.model
        .DeleteAllowListRequest(id, ignoreJobChecks.map(value => value))
    def id: __string
    def ignoreJobChecks: Optional[__string]
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getIgnoreJobChecks: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("ignoreJobChecks", ignoreJobChecks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.DeleteAllowListRequest
  ) extends zio.aws.macie2.model.DeleteAllowListRequest.ReadOnly {
    override val id: __string = impl.id(): __string
    override val ignoreJobChecks: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.ignoreJobChecks())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.DeleteAllowListRequest
  ): zio.aws.macie2.model.DeleteAllowListRequest.ReadOnly = new Wrapper(impl)
}
