package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__long, __string, __boolean}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClassificationResult(
    additionalOccurrences: Optional[__boolean] = Optional.Absent,
    customDataIdentifiers: Optional[
      zio.aws.macie2.model.CustomDataIdentifiers
    ] = Optional.Absent,
    mimeType: Optional[__string] = Optional.Absent,
    sensitiveData: Optional[Iterable[zio.aws.macie2.model.SensitiveDataItem]] =
      Optional.Absent,
    sizeClassified: Optional[__long] = Optional.Absent,
    status: Optional[zio.aws.macie2.model.ClassificationResultStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ClassificationResult = {
    import ClassificationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ClassificationResult
      .builder()
      .optionallyWith(
        additionalOccurrences.map(value => value: java.lang.Boolean)
      )(_.additionalOccurrences)
      .optionallyWith(
        customDataIdentifiers.map(value => value.buildAwsValue())
      )(_.customDataIdentifiers)
      .optionallyWith(mimeType.map(value => value: java.lang.String))(
        _.mimeType
      )
      .optionallyWith(
        sensitiveData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sensitiveData)
      .optionallyWith(sizeClassified.map(value => value: java.lang.Long))(
        _.sizeClassified
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ClassificationResult.ReadOnly =
    zio.aws.macie2.model.ClassificationResult.wrap(buildAwsValue())
}
object ClassificationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ClassificationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ClassificationResult =
      zio.aws.macie2.model.ClassificationResult(
        additionalOccurrences.map(value => value),
        customDataIdentifiers.map(value => value.asEditable),
        mimeType.map(value => value),
        sensitiveData.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sizeClassified.map(value => value),
        status.map(value => value.asEditable)
      )
    def additionalOccurrences: Optional[__boolean]
    def customDataIdentifiers
        : Optional[zio.aws.macie2.model.CustomDataIdentifiers.ReadOnly]
    def mimeType: Optional[__string]
    def sensitiveData
        : Optional[List[zio.aws.macie2.model.SensitiveDataItem.ReadOnly]]
    def sizeClassified: Optional[__long]
    def status
        : Optional[zio.aws.macie2.model.ClassificationResultStatus.ReadOnly]
    def getAdditionalOccurrences: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("additionalOccurrences", additionalOccurrences)
    def getCustomDataIdentifiers: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.CustomDataIdentifiers.ReadOnly
    ] =
      AwsError.unwrapOptionField("customDataIdentifiers", customDataIdentifiers)
    def getMimeType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("mimeType", mimeType)
    def getSensitiveData: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.SensitiveDataItem.ReadOnly
    ]] = AwsError.unwrapOptionField("sensitiveData", sensitiveData)
    def getSizeClassified: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("sizeClassified", sizeClassified)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ClassificationResultStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationResult
  ) extends zio.aws.macie2.model.ClassificationResult.ReadOnly {
    override val additionalOccurrences: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalOccurrences())
        .map(value => value: __boolean)
    override val customDataIdentifiers
        : Optional[zio.aws.macie2.model.CustomDataIdentifiers.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customDataIdentifiers())
        .map(value => zio.aws.macie2.model.CustomDataIdentifiers.wrap(value))
    override val mimeType: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.mimeType())
      .map(value => value: __string)
    override val sensitiveData
        : Optional[List[zio.aws.macie2.model.SensitiveDataItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sensitiveData())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.SensitiveDataItem.wrap(item)
          }.toList
        )
    override val sizeClassified: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeClassified())
      .map(value => value: __long)
    override val status
        : Optional[zio.aws.macie2.model.ClassificationResultStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.macie2.model.ClassificationResultStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationResult
  ): zio.aws.macie2.model.ClassificationResult.ReadOnly = new Wrapper(impl)
}
