package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BucketPermissionConfiguration(
    accountLevelPermissions: Optional[
      zio.aws.macie2.model.AccountLevelPermissions
    ] = Optional.Absent,
    bucketLevelPermissions: Optional[
      zio.aws.macie2.model.BucketLevelPermissions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketPermissionConfiguration = {
    import BucketPermissionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketPermissionConfiguration
      .builder()
      .optionallyWith(
        accountLevelPermissions.map(value => value.buildAwsValue())
      )(_.accountLevelPermissions)
      .optionallyWith(
        bucketLevelPermissions.map(value => value.buildAwsValue())
      )(_.bucketLevelPermissions)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.BucketPermissionConfiguration.ReadOnly =
    zio.aws.macie2.model.BucketPermissionConfiguration.wrap(buildAwsValue())
}
object BucketPermissionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketPermissionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketPermissionConfiguration =
      zio.aws.macie2.model.BucketPermissionConfiguration(
        accountLevelPermissions.map(value => value.asEditable),
        bucketLevelPermissions.map(value => value.asEditable)
      )
    def accountLevelPermissions
        : Optional[zio.aws.macie2.model.AccountLevelPermissions.ReadOnly]
    def bucketLevelPermissions
        : Optional[zio.aws.macie2.model.BucketLevelPermissions.ReadOnly]
    def getAccountLevelPermissions: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.AccountLevelPermissions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accountLevelPermissions",
      accountLevelPermissions
    )
    def getBucketLevelPermissions: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.BucketLevelPermissions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketLevelPermissions",
      bucketLevelPermissions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketPermissionConfiguration
  ) extends zio.aws.macie2.model.BucketPermissionConfiguration.ReadOnly {
    override val accountLevelPermissions
        : Optional[zio.aws.macie2.model.AccountLevelPermissions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountLevelPermissions())
        .map(value => zio.aws.macie2.model.AccountLevelPermissions.wrap(value))
    override val bucketLevelPermissions
        : Optional[zio.aws.macie2.model.BucketLevelPermissions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketLevelPermissions())
        .map(value => zio.aws.macie2.model.BucketLevelPermissions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketPermissionConfiguration
  ): zio.aws.macie2.model.BucketPermissionConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
