package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait AllowListStatusCode {
  def unwrap: software.amazon.awssdk.services.macie2.model.AllowListStatusCode
}
object AllowListStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.AllowListStatusCode
  ): zio.aws.macie2.model.AllowListStatusCode = value match {
    case software.amazon.awssdk.services.macie2.model.AllowListStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.AllowListStatusCode.OK =>
      val r = OK
      r
    case software.amazon.awssdk.services.macie2.model.AllowListStatusCode.S3_OBJECT_NOT_FOUND =>
      val r = S3_OBJECT_NOT_FOUND
      r
    case software.amazon.awssdk.services.macie2.model.AllowListStatusCode.S3_USER_ACCESS_DENIED =>
      val r = S3_USER_ACCESS_DENIED
      r
    case software.amazon.awssdk.services.macie2.model.AllowListStatusCode.S3_OBJECT_ACCESS_DENIED =>
      val r = S3_OBJECT_ACCESS_DENIED
      r
    case software.amazon.awssdk.services.macie2.model.AllowListStatusCode.S3_THROTTLED =>
      val r = S3_THROTTLED
      r
    case software.amazon.awssdk.services.macie2.model.AllowListStatusCode.S3_OBJECT_OVERSIZE =>
      val r = S3_OBJECT_OVERSIZE
      r
    case software.amazon.awssdk.services.macie2.model.AllowListStatusCode.S3_OBJECT_EMPTY =>
      val r = S3_OBJECT_EMPTY
      r
    case software.amazon.awssdk.services.macie2.model.AllowListStatusCode.UNKNOWN_ERROR =>
      val r = UNKNOWN_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.AllowListStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AllowListStatusCode =
      software.amazon.awssdk.services.macie2.model.AllowListStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object OK extends zio.aws.macie2.model.AllowListStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AllowListStatusCode =
      software.amazon.awssdk.services.macie2.model.AllowListStatusCode.OK
  }
  case object S3_OBJECT_NOT_FOUND
      extends zio.aws.macie2.model.AllowListStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AllowListStatusCode =
      software.amazon.awssdk.services.macie2.model.AllowListStatusCode.S3_OBJECT_NOT_FOUND
  }
  case object S3_USER_ACCESS_DENIED
      extends zio.aws.macie2.model.AllowListStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AllowListStatusCode =
      software.amazon.awssdk.services.macie2.model.AllowListStatusCode.S3_USER_ACCESS_DENIED
  }
  case object S3_OBJECT_ACCESS_DENIED
      extends zio.aws.macie2.model.AllowListStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AllowListStatusCode =
      software.amazon.awssdk.services.macie2.model.AllowListStatusCode.S3_OBJECT_ACCESS_DENIED
  }
  case object S3_THROTTLED extends zio.aws.macie2.model.AllowListStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AllowListStatusCode =
      software.amazon.awssdk.services.macie2.model.AllowListStatusCode.S3_THROTTLED
  }
  case object S3_OBJECT_OVERSIZE
      extends zio.aws.macie2.model.AllowListStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AllowListStatusCode =
      software.amazon.awssdk.services.macie2.model.AllowListStatusCode.S3_OBJECT_OVERSIZE
  }
  case object S3_OBJECT_EMPTY extends zio.aws.macie2.model.AllowListStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AllowListStatusCode =
      software.amazon.awssdk.services.macie2.model.AllowListStatusCode.S3_OBJECT_EMPTY
  }
  case object UNKNOWN_ERROR extends zio.aws.macie2.model.AllowListStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.AllowListStatusCode =
      software.amazon.awssdk.services.macie2.model.AllowListStatusCode.UNKNOWN_ERROR
  }
}
