package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceStatistics(
    totalBytesClassified: Optional[__long] = Optional.Absent,
    totalDetections: Optional[__long] = Optional.Absent,
    totalDetectionsSuppressed: Optional[__long] = Optional.Absent,
    totalItemsClassified: Optional[__long] = Optional.Absent,
    totalItemsSensitive: Optional[__long] = Optional.Absent,
    totalItemsSkipped: Optional[__long] = Optional.Absent,
    totalItemsSkippedInvalidEncryption: Optional[__long] = Optional.Absent,
    totalItemsSkippedInvalidKms: Optional[__long] = Optional.Absent,
    totalItemsSkippedPermissionDenied: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ResourceStatistics = {
    import ResourceStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ResourceStatistics
      .builder()
      .optionallyWith(totalBytesClassified.map(value => value: java.lang.Long))(
        _.totalBytesClassified
      )
      .optionallyWith(totalDetections.map(value => value: java.lang.Long))(
        _.totalDetections
      )
      .optionallyWith(
        totalDetectionsSuppressed.map(value => value: java.lang.Long)
      )(_.totalDetectionsSuppressed)
      .optionallyWith(totalItemsClassified.map(value => value: java.lang.Long))(
        _.totalItemsClassified
      )
      .optionallyWith(totalItemsSensitive.map(value => value: java.lang.Long))(
        _.totalItemsSensitive
      )
      .optionallyWith(totalItemsSkipped.map(value => value: java.lang.Long))(
        _.totalItemsSkipped
      )
      .optionallyWith(
        totalItemsSkippedInvalidEncryption.map(value => value: java.lang.Long)
      )(_.totalItemsSkippedInvalidEncryption)
      .optionallyWith(
        totalItemsSkippedInvalidKms.map(value => value: java.lang.Long)
      )(_.totalItemsSkippedInvalidKms)
      .optionallyWith(
        totalItemsSkippedPermissionDenied.map(value => value: java.lang.Long)
      )(_.totalItemsSkippedPermissionDenied)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ResourceStatistics.ReadOnly =
    zio.aws.macie2.model.ResourceStatistics.wrap(buildAwsValue())
}
object ResourceStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ResourceStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ResourceStatistics =
      zio.aws.macie2.model.ResourceStatistics(
        totalBytesClassified.map(value => value),
        totalDetections.map(value => value),
        totalDetectionsSuppressed.map(value => value),
        totalItemsClassified.map(value => value),
        totalItemsSensitive.map(value => value),
        totalItemsSkipped.map(value => value),
        totalItemsSkippedInvalidEncryption.map(value => value),
        totalItemsSkippedInvalidKms.map(value => value),
        totalItemsSkippedPermissionDenied.map(value => value)
      )
    def totalBytesClassified: Optional[__long]
    def totalDetections: Optional[__long]
    def totalDetectionsSuppressed: Optional[__long]
    def totalItemsClassified: Optional[__long]
    def totalItemsSensitive: Optional[__long]
    def totalItemsSkipped: Optional[__long]
    def totalItemsSkippedInvalidEncryption: Optional[__long]
    def totalItemsSkippedInvalidKms: Optional[__long]
    def totalItemsSkippedPermissionDenied: Optional[__long]
    def getTotalBytesClassified: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("totalBytesClassified", totalBytesClassified)
    def getTotalDetections: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("totalDetections", totalDetections)
    def getTotalDetectionsSuppressed: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("totalDetectionsSuppressed", totalDetectionsSuppressed)
    def getTotalItemsClassified: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("totalItemsClassified", totalItemsClassified)
    def getTotalItemsSensitive: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("totalItemsSensitive", totalItemsSensitive)
    def getTotalItemsSkipped: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("totalItemsSkipped", totalItemsSkipped)
    def getTotalItemsSkippedInvalidEncryption: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField(
        "totalItemsSkippedInvalidEncryption",
        totalItemsSkippedInvalidEncryption
      )
    def getTotalItemsSkippedInvalidKms: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField(
        "totalItemsSkippedInvalidKms",
        totalItemsSkippedInvalidKms
      )
    def getTotalItemsSkippedPermissionDenied: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField(
        "totalItemsSkippedPermissionDenied",
        totalItemsSkippedPermissionDenied
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ResourceStatistics
  ) extends zio.aws.macie2.model.ResourceStatistics.ReadOnly {
    override val totalBytesClassified: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalBytesClassified())
      .map(value => value: __long)
    override val totalDetections: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalDetections())
      .map(value => value: __long)
    override val totalDetectionsSuppressed: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalDetectionsSuppressed())
        .map(value => value: __long)
    override val totalItemsClassified: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalItemsClassified())
      .map(value => value: __long)
    override val totalItemsSensitive: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalItemsSensitive())
      .map(value => value: __long)
    override val totalItemsSkipped: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalItemsSkipped())
      .map(value => value: __long)
    override val totalItemsSkippedInvalidEncryption: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalItemsSkippedInvalidEncryption())
        .map(value => value: __long)
    override val totalItemsSkippedInvalidKms: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalItemsSkippedInvalidKms())
        .map(value => value: __long)
    override val totalItemsSkippedPermissionDenied: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalItemsSkippedPermissionDenied())
        .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ResourceStatistics
  ): zio.aws.macie2.model.ResourceStatistics.ReadOnly = new Wrapper(impl)
}
