package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, __boolean}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReplicationDetails(
    replicated: Optional[__boolean] = Optional.Absent,
    replicatedExternally: Optional[__boolean] = Optional.Absent,
    replicationAccounts: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ReplicationDetails = {
    import ReplicationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ReplicationDetails
      .builder()
      .optionallyWith(replicated.map(value => value: java.lang.Boolean))(
        _.replicated
      )
      .optionallyWith(
        replicatedExternally.map(value => value: java.lang.Boolean)
      )(_.replicatedExternally)
      .optionallyWith(
        replicationAccounts.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicationAccounts)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ReplicationDetails.ReadOnly =
    zio.aws.macie2.model.ReplicationDetails.wrap(buildAwsValue())
}
object ReplicationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ReplicationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ReplicationDetails =
      zio.aws.macie2.model.ReplicationDetails(
        replicated.map(value => value),
        replicatedExternally.map(value => value),
        replicationAccounts.map(value => value)
      )
    def replicated: Optional[__boolean]
    def replicatedExternally: Optional[__boolean]
    def replicationAccounts: Optional[List[__string]]
    def getReplicated: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("replicated", replicated)
    def getReplicatedExternally: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("replicatedExternally", replicatedExternally)
    def getReplicationAccounts: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("replicationAccounts", replicationAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ReplicationDetails
  ) extends zio.aws.macie2.model.ReplicationDetails.ReadOnly {
    override val replicated: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.replicated())
      .map(value => value: __boolean)
    override val replicatedExternally: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicatedExternally())
        .map(value => value: __boolean)
    override val replicationAccounts: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationAccounts())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ReplicationDetails
  ): zio.aws.macie2.model.ReplicationDetails.ReadOnly = new Wrapper(impl)
}
