package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListClassificationJobsResponse(
    items: Optional[Iterable[zio.aws.macie2.model.JobSummary]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse = {
    import ListClassificationJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListClassificationJobsResponse.ReadOnly =
    zio.aws.macie2.model.ListClassificationJobsResponse.wrap(buildAwsValue())
}
object ListClassificationJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListClassificationJobsResponse =
      zio.aws.macie2.model.ListClassificationJobsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[List[zio.aws.macie2.model.JobSummary.ReadOnly]]
    def nextToken: Optional[__string]
    def getItems
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.JobSummary.ReadOnly]] =
      AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse
  ) extends zio.aws.macie2.model.ListClassificationJobsResponse.ReadOnly {
    override val items
        : Optional[List[zio.aws.macie2.model.JobSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.JobSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse
  ): zio.aws.macie2.model.ListClassificationJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
