package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ApiCallDetails(
    api: Optional[__string] = Optional.Absent,
    apiServiceName: Optional[__string] = Optional.Absent,
    firstSeen: Optional[__timestampIso8601] = Optional.Absent,
    lastSeen: Optional[__timestampIso8601] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ApiCallDetails = {
    import ApiCallDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ApiCallDetails
      .builder()
      .optionallyWith(api.map(value => value: java.lang.String))(_.api)
      .optionallyWith(apiServiceName.map(value => value: java.lang.String))(
        _.apiServiceName
      )
      .optionallyWith(firstSeen.map(value => value: Instant))(_.firstSeen)
      .optionallyWith(lastSeen.map(value => value: Instant))(_.lastSeen)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ApiCallDetails.ReadOnly =
    zio.aws.macie2.model.ApiCallDetails.wrap(buildAwsValue())
}
object ApiCallDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ApiCallDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ApiCallDetails =
      zio.aws.macie2.model.ApiCallDetails(
        api.map(value => value),
        apiServiceName.map(value => value),
        firstSeen.map(value => value),
        lastSeen.map(value => value)
      )
    def api: Optional[__string]
    def apiServiceName: Optional[__string]
    def firstSeen: Optional[__timestampIso8601]
    def lastSeen: Optional[__timestampIso8601]
    def getApi: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("api", api)
    def getApiServiceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiServiceName", apiServiceName)
    def getFirstSeen: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("firstSeen", firstSeen)
    def getLastSeen: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastSeen", lastSeen)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ApiCallDetails
  ) extends zio.aws.macie2.model.ApiCallDetails.ReadOnly {
    override val api: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.api())
      .map(value => value: __string)
    override val apiServiceName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.apiServiceName())
      .map(value => value: __string)
    override val firstSeen: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.firstSeen())
      .map(value => value: __timestampIso8601)
    override val lastSeen: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSeen())
      .map(value => value: __timestampIso8601)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ApiCallDetails
  ): zio.aws.macie2.model.ApiCallDetails.ReadOnly = new Wrapper(impl)
}
