package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetUsageTotalsResponse(
    timeRange: Optional[zio.aws.macie2.model.TimeRange] = Optional.Absent,
    usageTotals: Optional[Iterable[zio.aws.macie2.model.UsageTotal]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse = {
    import GetUsageTotalsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse
      .builder()
      .optionallyWith(timeRange.map(value => value.unwrap))(_.timeRange)
      .optionallyWith(
        usageTotals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.usageTotals)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetUsageTotalsResponse.ReadOnly =
    zio.aws.macie2.model.GetUsageTotalsResponse.wrap(buildAwsValue())
}
object GetUsageTotalsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetUsageTotalsResponse =
      zio.aws.macie2.model.GetUsageTotalsResponse(
        timeRange.map(value => value),
        usageTotals.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def timeRange: Optional[zio.aws.macie2.model.TimeRange]
    def usageTotals: Optional[List[zio.aws.macie2.model.UsageTotal.ReadOnly]]
    def getTimeRange: ZIO[Any, AwsError, zio.aws.macie2.model.TimeRange] =
      AwsError.unwrapOptionField("timeRange", timeRange)
    def getUsageTotals
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.UsageTotal.ReadOnly]] =
      AwsError.unwrapOptionField("usageTotals", usageTotals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse
  ) extends zio.aws.macie2.model.GetUsageTotalsResponse.ReadOnly {
    override val timeRange: Optional[zio.aws.macie2.model.TimeRange] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeRange())
        .map(value => zio.aws.macie2.model.TimeRange.wrap(value))
    override val usageTotals
        : Optional[List[zio.aws.macie2.model.UsageTotal.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageTotals())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.UsageTotal.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse
  ): zio.aws.macie2.model.GetUsageTotalsResponse.ReadOnly = new Wrapper(impl)
}
