package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.__integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetFindingStatisticsRequest(
    findingCriteria: Optional[zio.aws.macie2.model.FindingCriteria] =
      Optional.Absent,
    groupBy: zio.aws.macie2.model.GroupBy,
    size: Optional[__integer] = Optional.Absent,
    sortCriteria: Optional[zio.aws.macie2.model.FindingStatisticsSortCriteria] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetFindingStatisticsRequest = {
    import GetFindingStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetFindingStatisticsRequest
      .builder()
      .optionallyWith(findingCriteria.map(value => value.buildAwsValue()))(
        _.findingCriteria
      )
      .groupBy(groupBy.unwrap)
      .optionallyWith(size.map(value => value: Integer))(_.size)
      .optionallyWith(sortCriteria.map(value => value.buildAwsValue()))(
        _.sortCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetFindingStatisticsRequest.ReadOnly =
    zio.aws.macie2.model.GetFindingStatisticsRequest.wrap(buildAwsValue())
}
object GetFindingStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetFindingStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetFindingStatisticsRequest =
      zio.aws.macie2.model.GetFindingStatisticsRequest(
        findingCriteria.map(value => value.asEditable),
        groupBy,
        size.map(value => value),
        sortCriteria.map(value => value.asEditable)
      )
    def findingCriteria: Optional[zio.aws.macie2.model.FindingCriteria.ReadOnly]
    def groupBy: zio.aws.macie2.model.GroupBy
    def size: Optional[__integer]
    def sortCriteria
        : Optional[zio.aws.macie2.model.FindingStatisticsSortCriteria.ReadOnly]
    def getFindingCriteria
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingCriteria.ReadOnly] =
      AwsError.unwrapOptionField("findingCriteria", findingCriteria)
    def getGroupBy: ZIO[Any, Nothing, zio.aws.macie2.model.GroupBy] =
      ZIO.succeed(groupBy)
    def getSize: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("size", size)
    def getSortCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.FindingStatisticsSortCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("sortCriteria", sortCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingStatisticsRequest
  ) extends zio.aws.macie2.model.GetFindingStatisticsRequest.ReadOnly {
    override val findingCriteria
        : Optional[zio.aws.macie2.model.FindingCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingCriteria())
        .map(value => zio.aws.macie2.model.FindingCriteria.wrap(value))
    override val groupBy: zio.aws.macie2.model.GroupBy =
      zio.aws.macie2.model.GroupBy.wrap(impl.groupBy())
    override val size: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: __integer)
    override val sortCriteria: Optional[
      zio.aws.macie2.model.FindingStatisticsSortCriteria.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sortCriteria())
      .map(value =>
        zio.aws.macie2.model.FindingStatisticsSortCriteria.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetFindingStatisticsRequest
  ): zio.aws.macie2.model.GetFindingStatisticsRequest.ReadOnly = new Wrapper(
    impl
  )
}
