package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TagCriterionForJob(
    comparator: Optional[zio.aws.macie2.model.JobComparator] = Optional.Absent,
    tagValues: Optional[Iterable[zio.aws.macie2.model.TagCriterionPairForJob]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.TagCriterionForJob = {
    import TagCriterionForJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.TagCriterionForJob
      .builder()
      .optionallyWith(comparator.map(value => value.unwrap))(_.comparator)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagValues)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.TagCriterionForJob.ReadOnly =
    zio.aws.macie2.model.TagCriterionForJob.wrap(buildAwsValue())
}
object TagCriterionForJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.TagCriterionForJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.TagCriterionForJob =
      zio.aws.macie2.model.TagCriterionForJob(
        comparator.map(value => value),
        tagValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def comparator: Optional[zio.aws.macie2.model.JobComparator]
    def tagValues
        : Optional[List[zio.aws.macie2.model.TagCriterionPairForJob.ReadOnly]]
    def getComparator: ZIO[Any, AwsError, zio.aws.macie2.model.JobComparator] =
      AwsError.unwrapOptionField("comparator", comparator)
    def getTagValues: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.TagCriterionPairForJob.ReadOnly
    ]] = AwsError.unwrapOptionField("tagValues", tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.TagCriterionForJob
  ) extends zio.aws.macie2.model.TagCriterionForJob.ReadOnly {
    override val comparator: Optional[zio.aws.macie2.model.JobComparator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comparator())
        .map(value => zio.aws.macie2.model.JobComparator.wrap(value))
    override val tagValues
        : Optional[List[zio.aws.macie2.model.TagCriterionPairForJob.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.TagCriterionPairForJob.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.TagCriterionForJob
  ): zio.aws.macie2.model.TagCriterionForJob.ReadOnly = new Wrapper(impl)
}
