package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait RevealStatus {
  def unwrap: software.amazon.awssdk.services.macie2.model.RevealStatus
}
object RevealStatus {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.RevealStatus
  ): zio.aws.macie2.model.RevealStatus = value match {
    case software.amazon.awssdk.services.macie2.model.RevealStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.RevealStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.macie2.model.RevealStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.RevealStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RevealStatus =
      software.amazon.awssdk.services.macie2.model.RevealStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.macie2.model.RevealStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RevealStatus =
      software.amazon.awssdk.services.macie2.model.RevealStatus.ENABLED
  }
  case object DISABLED extends zio.aws.macie2.model.RevealStatus {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.RevealStatus =
      software.amazon.awssdk.services.macie2.model.RevealStatus.DISABLED
  }
}
