package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait EncryptionType {
  def unwrap: software.amazon.awssdk.services.macie2.model.EncryptionType
}
object EncryptionType {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.EncryptionType
  ): zio.aws.macie2.model.EncryptionType = value match {
    case software.amazon.awssdk.services.macie2.model.EncryptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.EncryptionType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.macie2.model.EncryptionType.AES256 =>
      val r = AES256
      r
    case software.amazon.awssdk.services.macie2.model.EncryptionType.AWS_KMS =>
      val r = `aws:kms`
      r
    case software.amazon.awssdk.services.macie2.model.EncryptionType.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.EncryptionType =
      software.amazon.awssdk.services.macie2.model.EncryptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.macie2.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.EncryptionType =
      software.amazon.awssdk.services.macie2.model.EncryptionType.NONE
  }
  case object AES256 extends zio.aws.macie2.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.EncryptionType =
      software.amazon.awssdk.services.macie2.model.EncryptionType.AES256
  }
  case object `aws:kms` extends zio.aws.macie2.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.EncryptionType =
      software.amazon.awssdk.services.macie2.model.EncryptionType.AWS_KMS
  }
  case object UNKNOWN extends zio.aws.macie2.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.EncryptionType =
      software.amazon.awssdk.services.macie2.model.EncryptionType.UNKNOWN
  }
}
