package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UnprocessedAccount(
    accountId: Optional[__string] = Optional.Absent,
    errorCode: Optional[zio.aws.macie2.model.ErrorCode] = Optional.Absent,
    errorMessage: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UnprocessedAccount = {
    import UnprocessedAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UnprocessedAccount
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UnprocessedAccount.ReadOnly =
    zio.aws.macie2.model.UnprocessedAccount.wrap(buildAwsValue())
}
object UnprocessedAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UnprocessedAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UnprocessedAccount =
      zio.aws.macie2.model.UnprocessedAccount(
        accountId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def accountId: Optional[__string]
    def errorCode: Optional[zio.aws.macie2.model.ErrorCode]
    def errorMessage: Optional[__string]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getErrorCode: ZIO[Any, AwsError, zio.aws.macie2.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UnprocessedAccount
  ) extends zio.aws.macie2.model.UnprocessedAccount.ReadOnly {
    override val accountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: __string)
    override val errorCode: Optional[zio.aws.macie2.model.ErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.macie2.model.ErrorCode.wrap(value))
    override val errorMessage: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UnprocessedAccount
  ): zio.aws.macie2.model.UnprocessedAccount.ReadOnly = new Wrapper(impl)
}
