package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SensitivityAggregations(
    classifiableSizeInBytes: Optional[__long] = Optional.Absent,
    publiclyAccessibleCount: Optional[__long] = Optional.Absent,
    totalCount: Optional[__long] = Optional.Absent,
    totalSizeInBytes: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SensitivityAggregations = {
    import SensitivityAggregations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SensitivityAggregations
      .builder()
      .optionallyWith(
        classifiableSizeInBytes.map(value => value: java.lang.Long)
      )(_.classifiableSizeInBytes)
      .optionallyWith(
        publiclyAccessibleCount.map(value => value: java.lang.Long)
      )(_.publiclyAccessibleCount)
      .optionallyWith(totalCount.map(value => value: java.lang.Long))(
        _.totalCount
      )
      .optionallyWith(totalSizeInBytes.map(value => value: java.lang.Long))(
        _.totalSizeInBytes
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SensitivityAggregations.ReadOnly =
    zio.aws.macie2.model.SensitivityAggregations.wrap(buildAwsValue())
}
object SensitivityAggregations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SensitivityAggregations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SensitivityAggregations =
      zio.aws.macie2.model.SensitivityAggregations(
        classifiableSizeInBytes.map(value => value),
        publiclyAccessibleCount.map(value => value),
        totalCount.map(value => value),
        totalSizeInBytes.map(value => value)
      )
    def classifiableSizeInBytes: Optional[__long]
    def publiclyAccessibleCount: Optional[__long]
    def totalCount: Optional[__long]
    def totalSizeInBytes: Optional[__long]
    def getClassifiableSizeInBytes: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("classifiableSizeInBytes", classifiableSizeInBytes)
    def getPubliclyAccessibleCount: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("publiclyAccessibleCount", publiclyAccessibleCount)
    def getTotalCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("totalCount", totalCount)
    def getTotalSizeInBytes: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("totalSizeInBytes", totalSizeInBytes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SensitivityAggregations
  ) extends zio.aws.macie2.model.SensitivityAggregations.ReadOnly {
    override val classifiableSizeInBytes: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.classifiableSizeInBytes())
        .map(value => value: __long)
    override val publiclyAccessibleCount: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessibleCount())
        .map(value => value: __long)
    override val totalCount: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => value: __long)
    override val totalSizeInBytes: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalSizeInBytes())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SensitivityAggregations
  ): zio.aws.macie2.model.SensitivityAggregations.ReadOnly = new Wrapper(impl)
}
