package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SensitiveDataItem(
    category: Optional[zio.aws.macie2.model.SensitiveDataItemCategory] =
      Optional.Absent,
    detections: Optional[Iterable[zio.aws.macie2.model.DefaultDetection]] =
      Optional.Absent,
    totalCount: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SensitiveDataItem = {
    import SensitiveDataItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SensitiveDataItem
      .builder()
      .optionallyWith(category.map(value => value.unwrap))(_.category)
      .optionallyWith(
        detections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.detections)
      .optionallyWith(totalCount.map(value => value: java.lang.Long))(
        _.totalCount
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SensitiveDataItem.ReadOnly =
    zio.aws.macie2.model.SensitiveDataItem.wrap(buildAwsValue())
}
object SensitiveDataItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SensitiveDataItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SensitiveDataItem =
      zio.aws.macie2.model.SensitiveDataItem(
        category.map(value => value),
        detections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalCount.map(value => value)
      )
    def category: Optional[zio.aws.macie2.model.SensitiveDataItemCategory]
    def detections
        : Optional[List[zio.aws.macie2.model.DefaultDetection.ReadOnly]]
    def totalCount: Optional[__long]
    def getCategory
        : ZIO[Any, AwsError, zio.aws.macie2.model.SensitiveDataItemCategory] =
      AwsError.unwrapOptionField("category", category)
    def getDetections: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.DefaultDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("detections", detections)
    def getTotalCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SensitiveDataItem
  ) extends zio.aws.macie2.model.SensitiveDataItem.ReadOnly {
    override val category
        : Optional[zio.aws.macie2.model.SensitiveDataItemCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.category())
        .map(value =>
          zio.aws.macie2.model.SensitiveDataItemCategory.wrap(value)
        )
    override val detections
        : Optional[List[zio.aws.macie2.model.DefaultDetection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.DefaultDetection.wrap(item)
          }.toList
        )
    override val totalCount: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SensitiveDataItem
  ): zio.aws.macie2.model.SensitiveDataItem.ReadOnly = new Wrapper(impl)
}
