package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3JobDefinition(
    bucketCriteria: Optional[zio.aws.macie2.model.S3BucketCriteriaForJob] =
      Optional.Absent,
    bucketDefinitions: Optional[
      Iterable[zio.aws.macie2.model.S3BucketDefinitionForJob]
    ] = Optional.Absent,
    scoping: Optional[zio.aws.macie2.model.Scoping] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.S3JobDefinition = {
    import S3JobDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3JobDefinition
      .builder()
      .optionallyWith(bucketCriteria.map(value => value.buildAwsValue()))(
        _.bucketCriteria
      )
      .optionallyWith(
        bucketDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bucketDefinitions)
      .optionallyWith(scoping.map(value => value.buildAwsValue()))(_.scoping)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3JobDefinition.ReadOnly =
    zio.aws.macie2.model.S3JobDefinition.wrap(buildAwsValue())
}
object S3JobDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.S3JobDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3JobDefinition =
      zio.aws.macie2.model.S3JobDefinition(
        bucketCriteria.map(value => value.asEditable),
        bucketDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scoping.map(value => value.asEditable)
      )
    def bucketCriteria
        : Optional[zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly]
    def bucketDefinitions
        : Optional[List[zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly]]
    def scoping: Optional[zio.aws.macie2.model.Scoping.ReadOnly]
    def getBucketCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly
    ] = AwsError.unwrapOptionField("bucketCriteria", bucketCriteria)
    def getBucketDefinitions: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly
    ]] = AwsError.unwrapOptionField("bucketDefinitions", bucketDefinitions)
    def getScoping: ZIO[Any, AwsError, zio.aws.macie2.model.Scoping.ReadOnly] =
      AwsError.unwrapOptionField("scoping", scoping)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3JobDefinition
  ) extends zio.aws.macie2.model.S3JobDefinition.ReadOnly {
    override val bucketCriteria
        : Optional[zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketCriteria())
        .map(value => zio.aws.macie2.model.S3BucketCriteriaForJob.wrap(value))
    override val bucketDefinitions: Optional[
      List[zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.S3BucketDefinitionForJob.wrap(item)
        }.toList
      )
    override val scoping: Optional[zio.aws.macie2.model.Scoping.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scoping())
        .map(value => zio.aws.macie2.model.Scoping.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3JobDefinition
  ): zio.aws.macie2.model.S3JobDefinition.ReadOnly = new Wrapper(impl)
}
