package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutClassificationExportConfigurationRequest(
    configuration: zio.aws.macie2.model.ClassificationExportConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationRequest = {
    import PutClassificationExportConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationRequest
      .builder()
      .configuration(configuration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.PutClassificationExportConfigurationRequest.ReadOnly =
    zio.aws.macie2.model.PutClassificationExportConfigurationRequest
      .wrap(buildAwsValue())
}
object PutClassificationExportConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.macie2.model.PutClassificationExportConfigurationRequest =
      zio.aws.macie2.model
        .PutClassificationExportConfigurationRequest(configuration.asEditable)
    def configuration
        : zio.aws.macie2.model.ClassificationExportConfiguration.ReadOnly
    def getConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.macie2.model.ClassificationExportConfiguration.ReadOnly
    ] = ZIO.succeed(configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationRequest
  ) extends zio.aws.macie2.model.PutClassificationExportConfigurationRequest.ReadOnly {
    override val configuration
        : zio.aws.macie2.model.ClassificationExportConfiguration.ReadOnly =
      zio.aws.macie2.model.ClassificationExportConfiguration
        .wrap(impl.configuration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationRequest
  ): zio.aws.macie2.model.PutClassificationExportConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
