package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{
  __stringMin1Max128Pattern,
  __stringMin1Max512PatternSS,
  __string
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAllowListRequest(
    clientToken: __string,
    criteria: zio.aws.macie2.model.AllowListCriteria,
    description: Optional[__stringMin1Max512PatternSS] = Optional.Absent,
    name: __stringMin1Max128Pattern,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateAllowListRequest = {
    import CreateAllowListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateAllowListRequest
      .builder()
      .clientToken(clientToken: java.lang.String)
      .criteria(criteria.buildAwsValue())
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .name(name: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CreateAllowListRequest.ReadOnly =
    zio.aws.macie2.model.CreateAllowListRequest.wrap(buildAwsValue())
}
object CreateAllowListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateAllowListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateAllowListRequest =
      zio.aws.macie2.model.CreateAllowListRequest(
        clientToken,
        criteria.asEditable,
        description.map(value => value),
        name,
        tags.map(value => value)
      )
    def clientToken: __string
    def criteria: zio.aws.macie2.model.AllowListCriteria.ReadOnly
    def description: Optional[__stringMin1Max512PatternSS]
    def name: __stringMin1Max128Pattern
    def tags: Optional[Map[__string, __string]]
    def getClientToken: ZIO[Any, Nothing, __string] = ZIO.succeed(clientToken)
    def getCriteria
        : ZIO[Any, Nothing, zio.aws.macie2.model.AllowListCriteria.ReadOnly] =
      ZIO.succeed(criteria)
    def getDescription: ZIO[Any, AwsError, __stringMin1Max512PatternSS] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, __stringMin1Max128Pattern] =
      ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateAllowListRequest
  ) extends zio.aws.macie2.model.CreateAllowListRequest.ReadOnly {
    override val clientToken: __string = impl.clientToken(): __string
    override val criteria: zio.aws.macie2.model.AllowListCriteria.ReadOnly =
      zio.aws.macie2.model.AllowListCriteria.wrap(impl.criteria())
    override val description: Optional[__stringMin1Max512PatternSS] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => value: __stringMin1Max512PatternSS)
    override val name: __stringMin1Max128Pattern =
      impl.name(): __stringMin1Max128Pattern
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateAllowListRequest
  ): zio.aws.macie2.model.CreateAllowListRequest.ReadOnly = new Wrapper(impl)
}
