package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CriteriaForJob(
    simpleCriterion: Optional[zio.aws.macie2.model.SimpleCriterionForJob] =
      Optional.Absent,
    tagCriterion: Optional[zio.aws.macie2.model.TagCriterionForJob] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CriteriaForJob = {
    import CriteriaForJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CriteriaForJob
      .builder()
      .optionallyWith(simpleCriterion.map(value => value.buildAwsValue()))(
        _.simpleCriterion
      )
      .optionallyWith(tagCriterion.map(value => value.buildAwsValue()))(
        _.tagCriterion
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CriteriaForJob.ReadOnly =
    zio.aws.macie2.model.CriteriaForJob.wrap(buildAwsValue())
}
object CriteriaForJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CriteriaForJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CriteriaForJob =
      zio.aws.macie2.model.CriteriaForJob(
        simpleCriterion.map(value => value.asEditable),
        tagCriterion.map(value => value.asEditable)
      )
    def simpleCriterion
        : Optional[zio.aws.macie2.model.SimpleCriterionForJob.ReadOnly]
    def tagCriterion: Optional[zio.aws.macie2.model.TagCriterionForJob.ReadOnly]
    def getSimpleCriterion: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SimpleCriterionForJob.ReadOnly
    ] = AwsError.unwrapOptionField("simpleCriterion", simpleCriterion)
    def getTagCriterion
        : ZIO[Any, AwsError, zio.aws.macie2.model.TagCriterionForJob.ReadOnly] =
      AwsError.unwrapOptionField("tagCriterion", tagCriterion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CriteriaForJob
  ) extends zio.aws.macie2.model.CriteriaForJob.ReadOnly {
    override val simpleCriterion
        : Optional[zio.aws.macie2.model.SimpleCriterionForJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.simpleCriterion())
        .map(value => zio.aws.macie2.model.SimpleCriterionForJob.wrap(value))
    override val tagCriterion
        : Optional[zio.aws.macie2.model.TagCriterionForJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagCriterion())
        .map(value => zio.aws.macie2.model.TagCriterionForJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CriteriaForJob
  ): zio.aws.macie2.model.CriteriaForJob.ReadOnly = new Wrapper(impl)
}
