package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BucketCountByEffectivePermission(
    publiclyAccessible: Optional[__long] = Optional.Absent,
    publiclyReadable: Optional[__long] = Optional.Absent,
    publiclyWritable: Optional[__long] = Optional.Absent,
    unknown: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketCountByEffectivePermission = {
    import BucketCountByEffectivePermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketCountByEffectivePermission
      .builder()
      .optionallyWith(publiclyAccessible.map(value => value: java.lang.Long))(
        _.publiclyAccessible
      )
      .optionallyWith(publiclyReadable.map(value => value: java.lang.Long))(
        _.publiclyReadable
      )
      .optionallyWith(publiclyWritable.map(value => value: java.lang.Long))(
        _.publiclyWritable
      )
      .optionallyWith(unknown.map(value => value: java.lang.Long))(_.unknown)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.BucketCountByEffectivePermission.ReadOnly =
    zio.aws.macie2.model.BucketCountByEffectivePermission.wrap(buildAwsValue())
}
object BucketCountByEffectivePermission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketCountByEffectivePermission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketCountByEffectivePermission =
      zio.aws.macie2.model.BucketCountByEffectivePermission(
        publiclyAccessible.map(value => value),
        publiclyReadable.map(value => value),
        publiclyWritable.map(value => value),
        unknown.map(value => value)
      )
    def publiclyAccessible: Optional[__long]
    def publiclyReadable: Optional[__long]
    def publiclyWritable: Optional[__long]
    def unknown: Optional[__long]
    def getPubliclyAccessible: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getPubliclyReadable: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("publiclyReadable", publiclyReadable)
    def getPubliclyWritable: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("publiclyWritable", publiclyWritable)
    def getUnknown: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("unknown", unknown)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketCountByEffectivePermission
  ) extends zio.aws.macie2.model.BucketCountByEffectivePermission.ReadOnly {
    override val publiclyAccessible: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: __long)
    override val publiclyReadable: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyReadable())
      .map(value => value: __long)
    override val publiclyWritable: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyWritable())
      .map(value => value: __long)
    override val unknown: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.unknown())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketCountByEffectivePermission
  ): zio.aws.macie2.model.BucketCountByEffectivePermission.ReadOnly =
    new Wrapper(impl)
}
