package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssumedRole(
    accessKeyId: Optional[__string] = Optional.Absent,
    accountId: Optional[__string] = Optional.Absent,
    arn: Optional[__string] = Optional.Absent,
    principalId: Optional[__string] = Optional.Absent,
    sessionContext: Optional[zio.aws.macie2.model.SessionContext] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AssumedRole = {
    import AssumedRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AssumedRole
      .builder()
      .optionallyWith(accessKeyId.map(value => value: java.lang.String))(
        _.accessKeyId
      )
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(principalId.map(value => value: java.lang.String))(
        _.principalId
      )
      .optionallyWith(sessionContext.map(value => value.buildAwsValue()))(
        _.sessionContext
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AssumedRole.ReadOnly =
    zio.aws.macie2.model.AssumedRole.wrap(buildAwsValue())
}
object AssumedRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.AssumedRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AssumedRole =
      zio.aws.macie2.model.AssumedRole(
        accessKeyId.map(value => value),
        accountId.map(value => value),
        arn.map(value => value),
        principalId.map(value => value),
        sessionContext.map(value => value.asEditable)
      )
    def accessKeyId: Optional[__string]
    def accountId: Optional[__string]
    def arn: Optional[__string]
    def principalId: Optional[__string]
    def sessionContext: Optional[zio.aws.macie2.model.SessionContext.ReadOnly]
    def getAccessKeyId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getPrincipalId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getSessionContext
        : ZIO[Any, AwsError, zio.aws.macie2.model.SessionContext.ReadOnly] =
      AwsError.unwrapOptionField("sessionContext", sessionContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AssumedRole
  ) extends zio.aws.macie2.model.AssumedRole.ReadOnly {
    override val accessKeyId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accessKeyId())
      .map(value => value: __string)
    override val accountId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: __string)
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val principalId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => value: __string)
    override val sessionContext
        : Optional[zio.aws.macie2.model.SessionContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionContext())
        .map(value => zio.aws.macie2.model.SessionContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AssumedRole
  ): zio.aws.macie2.model.AssumedRole.ReadOnly = new Wrapper(impl)
}
