package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Page(
    lineRange: Optional[zio.aws.macie2.model.Range] = Optional.Absent,
    offsetRange: Optional[zio.aws.macie2.model.Range] = Optional.Absent,
    pageNumber: Optional[__long] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.Page = {
    import Page.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Page
      .builder()
      .optionallyWith(lineRange.map(value => value.buildAwsValue()))(
        _.lineRange
      )
      .optionallyWith(offsetRange.map(value => value.buildAwsValue()))(
        _.offsetRange
      )
      .optionallyWith(pageNumber.map(value => value: java.lang.Long))(
        _.pageNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Page.ReadOnly =
    zio.aws.macie2.model.Page.wrap(buildAwsValue())
}
object Page {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.Page] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Page = zio.aws.macie2.model.Page(
      lineRange.map(value => value.asEditable),
      offsetRange.map(value => value.asEditable),
      pageNumber.map(value => value)
    )
    def lineRange: Optional[zio.aws.macie2.model.Range.ReadOnly]
    def offsetRange: Optional[zio.aws.macie2.model.Range.ReadOnly]
    def pageNumber: Optional[__long]
    def getLineRange: ZIO[Any, AwsError, zio.aws.macie2.model.Range.ReadOnly] =
      AwsError.unwrapOptionField("lineRange", lineRange)
    def getOffsetRange
        : ZIO[Any, AwsError, zio.aws.macie2.model.Range.ReadOnly] =
      AwsError.unwrapOptionField("offsetRange", offsetRange)
    def getPageNumber: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("pageNumber", pageNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Page
  ) extends zio.aws.macie2.model.Page.ReadOnly {
    override val lineRange: Optional[zio.aws.macie2.model.Range.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineRange())
        .map(value => zio.aws.macie2.model.Range.wrap(value))
    override val offsetRange: Optional[zio.aws.macie2.model.Range.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offsetRange())
        .map(value => zio.aws.macie2.model.Range.wrap(value))
    override val pageNumber: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.pageNumber())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Page
  ): zio.aws.macie2.model.Page.ReadOnly = new Wrapper(impl)
}
