package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BucketLevelPermissions(
    accessControlList: Optional[zio.aws.macie2.model.AccessControlList] =
      Optional.Absent,
    blockPublicAccess: Optional[zio.aws.macie2.model.BlockPublicAccess] =
      Optional.Absent,
    bucketPolicy: Optional[zio.aws.macie2.model.BucketPolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketLevelPermissions = {
    import BucketLevelPermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketLevelPermissions
      .builder()
      .optionallyWith(accessControlList.map(value => value.buildAwsValue()))(
        _.accessControlList
      )
      .optionallyWith(blockPublicAccess.map(value => value.buildAwsValue()))(
        _.blockPublicAccess
      )
      .optionallyWith(bucketPolicy.map(value => value.buildAwsValue()))(
        _.bucketPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.BucketLevelPermissions.ReadOnly =
    zio.aws.macie2.model.BucketLevelPermissions.wrap(buildAwsValue())
}
object BucketLevelPermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketLevelPermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketLevelPermissions =
      zio.aws.macie2.model.BucketLevelPermissions(
        accessControlList.map(value => value.asEditable),
        blockPublicAccess.map(value => value.asEditable),
        bucketPolicy.map(value => value.asEditable)
      )
    def accessControlList
        : Optional[zio.aws.macie2.model.AccessControlList.ReadOnly]
    def blockPublicAccess
        : Optional[zio.aws.macie2.model.BlockPublicAccess.ReadOnly]
    def bucketPolicy: Optional[zio.aws.macie2.model.BucketPolicy.ReadOnly]
    def getAccessControlList
        : ZIO[Any, AwsError, zio.aws.macie2.model.AccessControlList.ReadOnly] =
      AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getBlockPublicAccess
        : ZIO[Any, AwsError, zio.aws.macie2.model.BlockPublicAccess.ReadOnly] =
      AwsError.unwrapOptionField("blockPublicAccess", blockPublicAccess)
    def getBucketPolicy
        : ZIO[Any, AwsError, zio.aws.macie2.model.BucketPolicy.ReadOnly] =
      AwsError.unwrapOptionField("bucketPolicy", bucketPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketLevelPermissions
  ) extends zio.aws.macie2.model.BucketLevelPermissions.ReadOnly {
    override val accessControlList
        : Optional[zio.aws.macie2.model.AccessControlList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessControlList())
        .map(value => zio.aws.macie2.model.AccessControlList.wrap(value))
    override val blockPublicAccess
        : Optional[zio.aws.macie2.model.BlockPublicAccess.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockPublicAccess())
        .map(value => zio.aws.macie2.model.BlockPublicAccess.wrap(value))
    override val bucketPolicy
        : Optional[zio.aws.macie2.model.BucketPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketPolicy())
        .map(value => zio.aws.macie2.model.BucketPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketLevelPermissions
  ): zio.aws.macie2.model.BucketLevelPermissions.ReadOnly = new Wrapper(impl)
}
