package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListJobsSortCriteria(
    attributeName: Optional[zio.aws.macie2.model.ListJobsSortAttributeName] =
      Optional.Absent,
    orderBy: Optional[zio.aws.macie2.model.OrderBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListJobsSortCriteria = {
    import ListJobsSortCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListJobsSortCriteria
      .builder()
      .optionallyWith(attributeName.map(value => value.unwrap))(_.attributeName)
      .optionallyWith(orderBy.map(value => value.unwrap))(_.orderBy)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListJobsSortCriteria.ReadOnly =
    zio.aws.macie2.model.ListJobsSortCriteria.wrap(buildAwsValue())
}
object ListJobsSortCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListJobsSortCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListJobsSortCriteria =
      zio.aws.macie2.model.ListJobsSortCriteria(
        attributeName.map(value => value),
        orderBy.map(value => value)
      )
    def attributeName: Optional[zio.aws.macie2.model.ListJobsSortAttributeName]
    def orderBy: Optional[zio.aws.macie2.model.OrderBy]
    def getAttributeName
        : ZIO[Any, AwsError, zio.aws.macie2.model.ListJobsSortAttributeName] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getOrderBy: ZIO[Any, AwsError, zio.aws.macie2.model.OrderBy] =
      AwsError.unwrapOptionField("orderBy", orderBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListJobsSortCriteria
  ) extends zio.aws.macie2.model.ListJobsSortCriteria.ReadOnly {
    override val attributeName
        : Optional[zio.aws.macie2.model.ListJobsSortAttributeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeName())
        .map(value =>
          zio.aws.macie2.model.ListJobsSortAttributeName.wrap(value)
        )
    override val orderBy: Optional[zio.aws.macie2.model.OrderBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orderBy())
        .map(value => zio.aws.macie2.model.OrderBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListJobsSortCriteria
  ): zio.aws.macie2.model.ListJobsSortCriteria.ReadOnly = new Wrapper(impl)
}
