package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetUsageStatisticsResponse(
    nextToken: Optional[__string] = Optional.Absent,
    records: Optional[Iterable[zio.aws.macie2.model.UsageRecord]] =
      Optional.Absent,
    timeRange: Optional[zio.aws.macie2.model.TimeRange] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse = {
    import GetUsageStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        records.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.records)
      .optionallyWith(timeRange.map(value => value.unwrap))(_.timeRange)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetUsageStatisticsResponse.ReadOnly =
    zio.aws.macie2.model.GetUsageStatisticsResponse.wrap(buildAwsValue())
}
object GetUsageStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetUsageStatisticsResponse =
      zio.aws.macie2.model.GetUsageStatisticsResponse(
        nextToken.map(value => value),
        records.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        timeRange.map(value => value)
      )
    def nextToken: Optional[__string]
    def records: Optional[List[zio.aws.macie2.model.UsageRecord.ReadOnly]]
    def timeRange: Optional[zio.aws.macie2.model.TimeRange]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecords
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.UsageRecord.ReadOnly]] =
      AwsError.unwrapOptionField("records", records)
    def getTimeRange: ZIO[Any, AwsError, zio.aws.macie2.model.TimeRange] =
      AwsError.unwrapOptionField("timeRange", timeRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse
  ) extends zio.aws.macie2.model.GetUsageStatisticsResponse.ReadOnly {
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val records
        : Optional[List[zio.aws.macie2.model.UsageRecord.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.records())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.UsageRecord.wrap(item)
          }.toList
        )
    override val timeRange: Optional[zio.aws.macie2.model.TimeRange] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeRange())
        .map(value => zio.aws.macie2.model.TimeRange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse
  ): zio.aws.macie2.model.GetUsageStatisticsResponse.ReadOnly = new Wrapper(
    impl
  )
}
