package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAdministratorAccountResponse(
    administrator: Optional[zio.aws.macie2.model.Invitation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetAdministratorAccountResponse = {
    import GetAdministratorAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetAdministratorAccountResponse
      .builder()
      .optionallyWith(administrator.map(value => value.buildAwsValue()))(
        _.administrator
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.GetAdministratorAccountResponse.ReadOnly =
    zio.aws.macie2.model.GetAdministratorAccountResponse.wrap(buildAwsValue())
}
object GetAdministratorAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetAdministratorAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetAdministratorAccountResponse =
      zio.aws.macie2.model.GetAdministratorAccountResponse(
        administrator.map(value => value.asEditable)
      )
    def administrator: Optional[zio.aws.macie2.model.Invitation.ReadOnly]
    def getAdministrator
        : ZIO[Any, AwsError, zio.aws.macie2.model.Invitation.ReadOnly] =
      AwsError.unwrapOptionField("administrator", administrator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetAdministratorAccountResponse
  ) extends zio.aws.macie2.model.GetAdministratorAccountResponse.ReadOnly {
    override val administrator
        : Optional[zio.aws.macie2.model.Invitation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.administrator())
        .map(value => zio.aws.macie2.model.Invitation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetAdministratorAccountResponse
  ): zio.aws.macie2.model.GetAdministratorAccountResponse.ReadOnly =
    new Wrapper(impl)
}
