package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait UsageStatisticsSortKey {
  def unwrap
      : software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey
}
object UsageStatisticsSortKey {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey
  ): zio.aws.macie2.model.UsageStatisticsSortKey = value match {
    case software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey.ACCOUNT_ID =>
      val r = accountId
      r
    case software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey.TOTAL =>
      val r = total
      r
    case software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey.SERVICE_LIMIT_VALUE =>
      val r = serviceLimitValue
      r
    case software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey.FREE_TRIAL_START_DATE =>
      val r = freeTrialStartDate
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.UsageStatisticsSortKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey =
      software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey.UNKNOWN_TO_SDK_VERSION
  }
  case object accountId extends zio.aws.macie2.model.UsageStatisticsSortKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey =
      software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey.ACCOUNT_ID
  }
  case object total extends zio.aws.macie2.model.UsageStatisticsSortKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey =
      software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey.TOTAL
  }
  case object serviceLimitValue
      extends zio.aws.macie2.model.UsageStatisticsSortKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey =
      software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey.SERVICE_LIMIT_VALUE
  }
  case object freeTrialStartDate
      extends zio.aws.macie2.model.UsageStatisticsSortKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey =
      software.amazon.awssdk.services.macie2.model.UsageStatisticsSortKey.FREE_TRIAL_START_DATE
  }
}
