package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListResourceProfileArtifactsResponse(
    artifacts: Optional[
      Iterable[zio.aws.macie2.model.ResourceProfileArtifact]
    ] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsResponse = {
    import ListResourceProfileArtifactsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsResponse
      .builder()
      .optionallyWith(
        artifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.artifacts)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ListResourceProfileArtifactsResponse.ReadOnly =
    zio.aws.macie2.model.ListResourceProfileArtifactsResponse
      .wrap(buildAwsValue())
}
object ListResourceProfileArtifactsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListResourceProfileArtifactsResponse =
      zio.aws.macie2.model.ListResourceProfileArtifactsResponse(
        artifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def artifacts
        : Optional[List[zio.aws.macie2.model.ResourceProfileArtifact.ReadOnly]]
    def nextToken: Optional[__string]
    def getArtifacts: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.ResourceProfileArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("artifacts", artifacts)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsResponse
  ) extends zio.aws.macie2.model.ListResourceProfileArtifactsResponse.ReadOnly {
    override val artifacts: Optional[
      List[zio.aws.macie2.model.ResourceProfileArtifact.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.artifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.ResourceProfileArtifact.wrap(item)
        }.toList
      )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsResponse
  ): zio.aws.macie2.model.ListResourceProfileArtifactsResponse.ReadOnly =
    new Wrapper(impl)
}
