package zio.aws.macie2.model
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeBucketsRequest(
    criteria: Optional[
      Map[__string, zio.aws.macie2.model.BucketCriteriaAdditionalProperties]
    ] = Optional.Absent,
    maxResults: Optional[__integer] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    sortCriteria: Optional[zio.aws.macie2.model.BucketSortCriteria] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest = {
    import DescribeBucketsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest
      .builder()
      .optionallyWith(
        criteria.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.criteria)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(sortCriteria.map(value => value.buildAwsValue()))(
        _.sortCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.DescribeBucketsRequest.ReadOnly =
    zio.aws.macie2.model.DescribeBucketsRequest.wrap(buildAwsValue())
}
object DescribeBucketsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.DescribeBucketsRequest =
      zio.aws.macie2.model.DescribeBucketsRequest(
        criteria.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortCriteria.map(value => value.asEditable)
      )
    def criteria: Optional[Map[
      __string,
      zio.aws.macie2.model.BucketCriteriaAdditionalProperties.ReadOnly
    ]]
    def maxResults: Optional[__integer]
    def nextToken: Optional[__string]
    def sortCriteria: Optional[zio.aws.macie2.model.BucketSortCriteria.ReadOnly]
    def getCriteria: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.macie2.model.BucketCriteriaAdditionalProperties.ReadOnly
    ]] = AwsError.unwrapOptionField("criteria", criteria)
    def getMaxResults: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortCriteria
        : ZIO[Any, AwsError, zio.aws.macie2.model.BucketSortCriteria.ReadOnly] =
      AwsError.unwrapOptionField("sortCriteria", sortCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest
  ) extends zio.aws.macie2.model.DescribeBucketsRequest.ReadOnly {
    override val criteria: Optional[Map[
      __string,
      zio.aws.macie2.model.BucketCriteriaAdditionalProperties.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.criteria())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.macie2.model.BucketCriteriaAdditionalProperties
              .wrap(value)
          })
          .toMap
      )
    override val maxResults: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: __integer)
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val sortCriteria
        : Optional[zio.aws.macie2.model.BucketSortCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortCriteria())
        .map(value => zio.aws.macie2.model.BucketSortCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest
  ): zio.aws.macie2.model.DescribeBucketsRequest.ReadOnly = new Wrapper(impl)
}
