package zio.aws.macie2.model
import scala.jdk.CollectionConverters.*
sealed trait UnavailabilityReasonCode {
  def unwrap
      : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode
}
object UnavailabilityReasonCode {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode
  ): zio.aws.macie2.model.UnavailabilityReasonCode = value match {
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.OBJECT_EXCEEDS_SIZE_QUOTA =>
      val r = OBJECT_EXCEEDS_SIZE_QUOTA
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.UNSUPPORTED_OBJECT_TYPE =>
      val r = UNSUPPORTED_OBJECT_TYPE
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.UNSUPPORTED_FINDING_TYPE =>
      val r = UNSUPPORTED_FINDING_TYPE
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.INVALID_CLASSIFICATION_RESULT =>
      val r = INVALID_CLASSIFICATION_RESULT
      r
    case software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.OBJECT_UNAVAILABLE =>
      val r = OBJECT_UNAVAILABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.UNKNOWN_TO_SDK_VERSION
  }
  case object OBJECT_EXCEEDS_SIZE_QUOTA
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.OBJECT_EXCEEDS_SIZE_QUOTA
  }
  case object UNSUPPORTED_OBJECT_TYPE
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.UNSUPPORTED_OBJECT_TYPE
  }
  case object UNSUPPORTED_FINDING_TYPE
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.UNSUPPORTED_FINDING_TYPE
  }
  case object INVALID_CLASSIFICATION_RESULT
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.INVALID_CLASSIFICATION_RESULT
  }
  case object OBJECT_UNAVAILABLE
      extends zio.aws.macie2.model.UnavailabilityReasonCode {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode =
      software.amazon.awssdk.services.macie2.model.UnavailabilityReasonCode.OBJECT_UNAVAILABLE
  }
}
