package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.macie2.model.primitives.S3BucketName
import scala.jdk.CollectionConverters.*
final case class S3ClassificationScopeExclusionUpdate(
    bucketNames: Iterable[S3BucketName],
    operation: zio.aws.macie2.model.ClassificationScopeUpdateOperation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.S3ClassificationScopeExclusionUpdate = {
    import S3ClassificationScopeExclusionUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3ClassificationScopeExclusionUpdate
      .builder()
      .bucketNames(bucketNames.map { item =>
        S3BucketName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operation(operation.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.S3ClassificationScopeExclusionUpdate.ReadOnly =
    zio.aws.macie2.model.S3ClassificationScopeExclusionUpdate
      .wrap(buildAwsValue())
}
object S3ClassificationScopeExclusionUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.S3ClassificationScopeExclusionUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3ClassificationScopeExclusionUpdate =
      zio.aws.macie2.model
        .S3ClassificationScopeExclusionUpdate(bucketNames, operation)
    def bucketNames: List[S3BucketName]
    def operation: zio.aws.macie2.model.ClassificationScopeUpdateOperation
    def getBucketNames: ZIO[Any, Nothing, List[S3BucketName]] =
      ZIO.succeed(bucketNames)
    def getOperation: ZIO[
      Any,
      Nothing,
      zio.aws.macie2.model.ClassificationScopeUpdateOperation
    ] = ZIO.succeed(operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3ClassificationScopeExclusionUpdate
  ) extends zio.aws.macie2.model.S3ClassificationScopeExclusionUpdate.ReadOnly {
    override val bucketNames: List[S3BucketName] = impl
      .bucketNames()
      .asScala
      .map { item =>
        zio.aws.macie2.model.primitives.S3BucketName(item)
      }
      .toList
    override val operation
        : zio.aws.macie2.model.ClassificationScopeUpdateOperation =
      zio.aws.macie2.model.ClassificationScopeUpdateOperation
        .wrap(impl.operation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3ClassificationScopeExclusionUpdate
  ): zio.aws.macie2.model.S3ClassificationScopeExclusionUpdate.ReadOnly =
    new Wrapper(impl)
}
