package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class S3BucketCriteriaForJob(
    excludes: Optional[zio.aws.macie2.model.CriteriaBlockForJob] =
      Optional.Absent,
    includes: Optional[zio.aws.macie2.model.CriteriaBlockForJob] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.S3BucketCriteriaForJob = {
    import S3BucketCriteriaForJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3BucketCriteriaForJob
      .builder()
      .optionallyWith(excludes.map(value => value.buildAwsValue()))(_.excludes)
      .optionallyWith(includes.map(value => value.buildAwsValue()))(_.includes)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly =
    zio.aws.macie2.model.S3BucketCriteriaForJob.wrap(buildAwsValue())
}
object S3BucketCriteriaForJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.S3BucketCriteriaForJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3BucketCriteriaForJob =
      zio.aws.macie2.model.S3BucketCriteriaForJob(
        excludes.map(value => value.asEditable),
        includes.map(value => value.asEditable)
      )
    def excludes: Optional[zio.aws.macie2.model.CriteriaBlockForJob.ReadOnly]
    def includes: Optional[zio.aws.macie2.model.CriteriaBlockForJob.ReadOnly]
    def getExcludes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.CriteriaBlockForJob.ReadOnly
    ] = AwsError.unwrapOptionField("excludes", excludes)
    def getIncludes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.CriteriaBlockForJob.ReadOnly
    ] = AwsError.unwrapOptionField("includes", includes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3BucketCriteriaForJob
  ) extends zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly {
    override val excludes
        : Optional[zio.aws.macie2.model.CriteriaBlockForJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludes())
        .map(value => zio.aws.macie2.model.CriteriaBlockForJob.wrap(value))
    override val includes
        : Optional[zio.aws.macie2.model.CriteriaBlockForJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includes())
        .map(value => zio.aws.macie2.model.CriteriaBlockForJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3BucketCriteriaForJob
  ): zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly = new Wrapper(impl)
}
