package zio.aws.macie2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class S3Bucket(
    allowsUnencryptedObjectUploads: Optional[
      zio.aws.macie2.model.AllowsUnencryptedObjectUploads
    ] = Optional.Absent,
    arn: Optional[__string] = Optional.Absent,
    createdAt: Optional[__timestampIso8601] = Optional.Absent,
    defaultServerSideEncryption: Optional[
      zio.aws.macie2.model.ServerSideEncryption
    ] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    owner: Optional[zio.aws.macie2.model.S3BucketOwner] = Optional.Absent,
    publicAccess: Optional[zio.aws.macie2.model.BucketPublicAccess] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.macie2.model.KeyValuePair]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.S3Bucket = {
    import S3Bucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3Bucket
      .builder()
      .optionallyWith(
        allowsUnencryptedObjectUploads.map(value => value.unwrap)
      )(_.allowsUnencryptedObjectUploads)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(
        defaultServerSideEncryption.map(value => value.buildAwsValue())
      )(_.defaultServerSideEncryption)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(publicAccess.map(value => value.buildAwsValue()))(
        _.publicAccess
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3Bucket.ReadOnly =
    zio.aws.macie2.model.S3Bucket.wrap(buildAwsValue())
}
object S3Bucket {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.S3Bucket] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3Bucket =
      zio.aws.macie2.model.S3Bucket(
        allowsUnencryptedObjectUploads.map(value => value),
        arn.map(value => value),
        createdAt.map(value => value),
        defaultServerSideEncryption.map(value => value.asEditable),
        name.map(value => value),
        owner.map(value => value.asEditable),
        publicAccess.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def allowsUnencryptedObjectUploads
        : Optional[zio.aws.macie2.model.AllowsUnencryptedObjectUploads]
    def arn: Optional[__string]
    def createdAt: Optional[__timestampIso8601]
    def defaultServerSideEncryption
        : Optional[zio.aws.macie2.model.ServerSideEncryption.ReadOnly]
    def name: Optional[__string]
    def owner: Optional[zio.aws.macie2.model.S3BucketOwner.ReadOnly]
    def publicAccess: Optional[zio.aws.macie2.model.BucketPublicAccess.ReadOnly]
    def tags: Optional[List[zio.aws.macie2.model.KeyValuePair.ReadOnly]]
    def getAllowsUnencryptedObjectUploads: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.AllowsUnencryptedObjectUploads
    ] = AwsError.unwrapOptionField(
      "allowsUnencryptedObjectUploads",
      allowsUnencryptedObjectUploads
    )
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDefaultServerSideEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ServerSideEncryption.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultServerSideEncryption",
      defaultServerSideEncryption
    )
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getOwner
        : ZIO[Any, AwsError, zio.aws.macie2.model.S3BucketOwner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
    def getPublicAccess
        : ZIO[Any, AwsError, zio.aws.macie2.model.BucketPublicAccess.ReadOnly] =
      AwsError.unwrapOptionField("publicAccess", publicAccess)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3Bucket
  ) extends zio.aws.macie2.model.S3Bucket.ReadOnly {
    override val allowsUnencryptedObjectUploads
        : Optional[zio.aws.macie2.model.AllowsUnencryptedObjectUploads] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowsUnencryptedObjectUploads())
        .map(value =>
          zio.aws.macie2.model.AllowsUnencryptedObjectUploads.wrap(value)
        )
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val createdAt: Optional[__timestampIso8601] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => value: __timestampIso8601)
    override val defaultServerSideEncryption
        : Optional[zio.aws.macie2.model.ServerSideEncryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultServerSideEncryption())
        .map(value => zio.aws.macie2.model.ServerSideEncryption.wrap(value))
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val owner: Optional[zio.aws.macie2.model.S3BucketOwner.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.macie2.model.S3BucketOwner.wrap(value))
    override val publicAccess
        : Optional[zio.aws.macie2.model.BucketPublicAccess.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicAccess())
        .map(value => zio.aws.macie2.model.BucketPublicAccess.wrap(value))
    override val tags
        : Optional[List[zio.aws.macie2.model.KeyValuePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.KeyValuePair.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3Bucket
  ): zio.aws.macie2.model.S3Bucket.ReadOnly = new Wrapper(impl)
}
