package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TagValuePair(
    key: Optional[__string] = Optional.Absent,
    value: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.TagValuePair = {
    import TagValuePair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.TagValuePair
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.TagValuePair.ReadOnly =
    zio.aws.macie2.model.TagValuePair.wrap(buildAwsValue())
}
object TagValuePair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.TagValuePair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.TagValuePair = zio.aws.macie2.model
      .TagValuePair(key.map(value => value), value.map(value => value))
    def key: Optional[__string]
    def value: Optional[__string]
    def getKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.TagValuePair
  ) extends zio.aws.macie2.model.TagValuePair.ReadOnly {
    override val key: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: __string)
    override val value: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.TagValuePair
  ): zio.aws.macie2.model.TagValuePair.ReadOnly = new Wrapper(impl)
}
