package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListJobsFilterCriteria(
    excludes: Optional[Iterable[zio.aws.macie2.model.ListJobsFilterTerm]] =
      Optional.Absent,
    includes: Optional[Iterable[zio.aws.macie2.model.ListJobsFilterTerm]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListJobsFilterCriteria = {
    import ListJobsFilterCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListJobsFilterCriteria
      .builder()
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludes)
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includes)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListJobsFilterCriteria.ReadOnly =
    zio.aws.macie2.model.ListJobsFilterCriteria.wrap(buildAwsValue())
}
object ListJobsFilterCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListJobsFilterCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListJobsFilterCriteria =
      zio.aws.macie2.model.ListJobsFilterCriteria(
        excludes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        includes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def excludes
        : Optional[List[zio.aws.macie2.model.ListJobsFilterTerm.ReadOnly]]
    def includes
        : Optional[List[zio.aws.macie2.model.ListJobsFilterTerm.ReadOnly]]
    def getExcludes: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.ListJobsFilterTerm.ReadOnly
    ]] = AwsError.unwrapOptionField("excludes", excludes)
    def getIncludes: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.ListJobsFilterTerm.ReadOnly
    ]] = AwsError.unwrapOptionField("includes", includes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListJobsFilterCriteria
  ) extends zio.aws.macie2.model.ListJobsFilterCriteria.ReadOnly {
    override val excludes
        : Optional[List[zio.aws.macie2.model.ListJobsFilterTerm.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.ListJobsFilterTerm.wrap(item)
          }.toList
        )
    override val includes
        : Optional[List[zio.aws.macie2.model.ListJobsFilterTerm.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.ListJobsFilterTerm.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListJobsFilterCriteria
  ): zio.aws.macie2.model.ListJobsFilterCriteria.ReadOnly = new Wrapper(impl)
}
