package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListInvitationsResponse(
    invitations: Optional[Iterable[zio.aws.macie2.model.Invitation]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListInvitationsResponse = {
    import ListInvitationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListInvitationsResponse
      .builder()
      .optionallyWith(
        invitations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.invitations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListInvitationsResponse.ReadOnly =
    zio.aws.macie2.model.ListInvitationsResponse.wrap(buildAwsValue())
}
object ListInvitationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListInvitationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListInvitationsResponse =
      zio.aws.macie2.model.ListInvitationsResponse(
        invitations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def invitations: Optional[List[zio.aws.macie2.model.Invitation.ReadOnly]]
    def nextToken: Optional[__string]
    def getInvitations
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.Invitation.ReadOnly]] =
      AwsError.unwrapOptionField("invitations", invitations)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListInvitationsResponse
  ) extends zio.aws.macie2.model.ListInvitationsResponse.ReadOnly {
    override val invitations
        : Optional[List[zio.aws.macie2.model.Invitation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invitations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.Invitation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListInvitationsResponse
  ): zio.aws.macie2.model.ListInvitationsResponse.ReadOnly = new Wrapper(impl)
}
